// QCapCaptureDevice.h : Declaration of the CQCapCaptureDevice
#pragma once
#include "resource.h"       // main symbols
#include <atlctl.h>
#include "QCAPATLAX_i.h"

#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif

using namespace ATL;



// CQCapCaptureDevice
class ATL_NO_VTABLE CQCapCaptureDevice :
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IQCapCaptureDevice, &IID_IQCapCaptureDevice, &LIBID_QCAPATLAXLib, /*wMajor =*/ 1, /*wMinor =*/ 0>,
	public IOleControlImpl<CQCapCaptureDevice>,
	public IOleObjectImpl<CQCapCaptureDevice>,
	public IOleInPlaceActiveObjectImpl<CQCapCaptureDevice>,
	public IViewObjectExImpl<CQCapCaptureDevice>,
	public IOleInPlaceObjectWindowlessImpl<CQCapCaptureDevice>,
	public ISupportErrorInfo,
	public IQuickActivateImpl<CQCapCaptureDevice>,
#ifndef _WIN32_WCE
	public IDataObjectImpl<CQCapCaptureDevice>,
#endif
	public IProvideClassInfo2Impl<&CLSID_QCapCaptureDevice, NULL, &LIBID_QCAPATLAXLib>,
	public CComCoClass<CQCapCaptureDevice, &CLSID_QCapCaptureDevice>,
	public CComControl<CQCapCaptureDevice>
{
public:
	CContainedWindow m_ctlStatic;

#pragma warning(push)
#pragma warning(disable: 4355) // 'this' : used in base member initializer list


	CQCapCaptureDevice()
		: m_ctlStatic(_T("Static"), this, 1)
	{
		m_bWindowOnly = TRUE;
	}

#pragma warning(pop)

DECLARE_OLEMISC_STATUS(OLEMISC_RECOMPOSEONRESIZE |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_INSIDEOUT |
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST
)

DECLARE_REGISTRY_RESOURCEID(IDR_QCAPCAPTUREDEVICE)


BEGIN_COM_MAP(CQCapCaptureDevice)
	COM_INTERFACE_ENTRY(IQCapCaptureDevice)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IQuickActivate)
#ifndef _WIN32_WCE
	COM_INTERFACE_ENTRY(IDataObject)
#endif
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
END_COM_MAP()

BEGIN_PROP_MAP(CQCapCaptureDevice)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY_TYPE("Property Name", dispid, clsid, vtType)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()


BEGIN_MSG_MAP(CQCapCaptureDevice)
	MESSAGE_HANDLER(WM_CREATE, OnCreate)
	MESSAGE_HANDLER(WM_DESTROY, OnDestroy)
	MESSAGE_HANDLER(WM_SETFOCUS, OnSetFocus)
	CHAIN_MSG_MAP(CComControl<CQCapCaptureDevice>)
ALT_MSG_MAP(1)
	// Replace this with message map entries for superclassed Static
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);

	LRESULT OnSetFocus(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
	{
		LRESULT lRes = CComControl<CQCapCaptureDevice>::OnSetFocus(uMsg, wParam, lParam, bHandled);
		if (m_bInPlaceActive)
		{
			if(!IsChild(::GetFocus()))
				m_ctlStatic.SetFocus();
		}
		return lRes;
	}

	LRESULT OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
	{
		SC_DEBUG( "CQCapCaptureDevice::OnCreate()" );

		RECT rc;
		GetWindowRect(&rc);
		rc.right -= rc.left;
		rc.bottom -= rc.top;
		rc.top = rc.left = 0;
		m_ctlStatic.Create(m_hWnd, rc);

		// CAREATE QCAP DEVICE
		//
		{	QCAP_CREATE( "CX2581 PCI", 0, m_ctlStatic.m_hWnd, &m_pDevice );

		//	QCAP_SET_DEFAULT_CAMERA( "USB2.0 Camera" );

		//	QCAP_CREATE( "CAMERA", 0, m_ctlStatic.m_hWnd, &m_pDevice );

			if( m_pDevice ) {

				QCAP_SET_VIDEO_STANDARD( m_pDevice, QCAP_STANDARD_TYPE_PAL_B );

				QCAP_RUN( m_pDevice );
			}
		}
		return 0;
	}
	
	LRESULT OnDestroy( UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
	{
		SC_DEBUG( "CQCapCaptureDevice::OnDestroy()" );

		// DESTROY QCAP DEVICE
		//
		if( m_pDevice ) {

			QCAP_STOP( m_pDevice );

			QCAP_DESTROY( m_pDevice );

			m_pDevice = NULL;
		}
		return 0;
	}

	STDMETHOD(SetObjectRects)(LPCRECT prcPos,LPCRECT prcClip)
	{
		IOleInPlaceObjectWindowlessImpl<CQCapCaptureDevice>::SetObjectRects(prcPos, prcClip);
		int cx, cy;
		cx = prcPos->right - prcPos->left;
		cy = prcPos->bottom - prcPos->top;
		::SetWindowPos(m_ctlStatic.m_hWnd, NULL, 0,
			0, cx, cy, SWP_NOZORDER | SWP_NOACTIVATE);
		return S_OK;
	}

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid)
	{
		static const IID* const arr[] =
		{
			&IID_IQCapCaptureDevice,
		};

		for (int i=0; i<sizeof(arr)/sizeof(arr[0]); i++)
		{
			if (InlineIsEqualGUID(*arr[i], riid))
				return S_OK;
		}
		return S_FALSE;
	}

// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IQCapCaptureDevice

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
	}

private:

	PVOID	m_pDevice;
};

OBJECT_ENTRY_AUTO(__uuidof(QCapCaptureDevice), CQCapCaptureDevice)
