// SC300Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC300.h"
#include "SC300Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

VOID SC_DEBUG( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[SC310] [00000000] ";

	va_list marker;

	va_start( marker, fmt );

	StringCbPrintfA( pszDebugDumpMessage + 8, sizeof(pszDebugDumpMessage), "[%08X] ", 0x00000000 );

	StringCbVPrintfA( pszDebugDumpMessage + 8 + 10 + 1, sizeof(pszDebugDumpMessage), fmt, marker );

	va_end( marker );

	StringCbCatA( pszDebugDumpMessage, sizeof(pszDebugDumpMessage), "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

ULONG  g_b_start_statsticis = FALSE;

ULONG  g_n_video_frame_number[ 32 ];

double g_d_video_start_sample_time[ 32 ];

double g_d_video_stop_sample_time[ 32 ];

ULONG  g_n_audio_sample_number[ 32 ];

double g_d_audio_start_sample_time[ 32 ];

double g_d_audio_stop_sample_time[ 32 ];

BOOL on_process_video_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	if( g_b_start_statsticis ) { 

		if( g_n_video_frame_number[ i ] == 0 ) {

			g_d_video_start_sample_time[ i ] = dSampleTime;
		}
		g_d_video_stop_sample_time[ i ] = dSampleTime;

		g_n_video_frame_number[ i ]++;
	}
	return FALSE;
}

BOOL on_process_audio_buffer( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	if( g_b_start_statsticis ) { 

		if( g_n_audio_sample_number[ i ] == 0 ) {

			g_d_audio_start_sample_time[ i ] = dSampleTime;
		}
		g_d_audio_stop_sample_time[ i ] = dSampleTime;

		g_n_audio_sample_number[ i ] += nBufferLen / 2;
	}
	return FALSE;
}

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC300Dlg dialog

CSC300Dlg::CSC300Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSC300Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSC300Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSC300Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSC300Dlg)
	DDX_Control(pDX, IDC_STATIC_DEBUG, m_staticDebugCtrl);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSC300Dlg, CDialog)
	//{{AFX_MSG_MAP(CSC300Dlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC300Dlg message handlers

BOOL CSC300Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	// [2010.10.04]
	//
	PF_BUFFER_CALLBACK bcb_video[ 32 ] = { on_process_video_buffer, on_process_video_buffer, on_process_video_buffer, on_process_video_buffer,
	
										   on_process_video_buffer, on_process_video_buffer, on_process_video_buffer, on_process_video_buffer,

										   on_process_video_buffer, on_process_video_buffer, on_process_video_buffer, on_process_video_buffer,

										   on_process_video_buffer, on_process_video_buffer, on_process_video_buffer, on_process_video_buffer,

										   on_process_video_buffer, on_process_video_buffer, on_process_video_buffer, on_process_video_buffer,

										   on_process_video_buffer, on_process_video_buffer, on_process_video_buffer, on_process_video_buffer,

										   on_process_video_buffer, on_process_video_buffer, on_process_video_buffer, on_process_video_buffer,

										   on_process_video_buffer, on_process_video_buffer, on_process_video_buffer, on_process_video_buffer,
	};
	PF_BUFFER_CALLBACK bcb_audio[ 32 ] = { on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer,
	
										   on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer,

										   on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer,

										   on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer,

										   on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer,

										   on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer,

										   on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer,

										   on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer, on_process_audio_buffer,
	};
	PVOID params[ 32 ] = { (PVOID)0, (PVOID)1, (PVOID)2, (PVOID)3, (PVOID)4, (PVOID)5, (PVOID)6, (PVOID)7, (PVOID)8, (PVOID)9, (PVOID)10, (PVOID)11, (PVOID)12, (PVOID)13, (PVOID)14, (PVOID)15, (PVOID)16, (PVOID)17, (PVOID)18, (PVOID)19, (PVOID)20, (PVOID)21, (PVOID)22, (PVOID)23, (PVOID)24, (PVOID)25, (PVOID)26, (PVOID)27, (PVOID)28, (PVOID)29, (PVOID)30, (PVOID)31 };

	HRESULT hr = CoInitialize( NULL );

	if( m_oAnalogDeviceVideoGraph.Create( L"CX2581 PCI", bcb_video, params ) == FALSE ) {

		m_oAnalogDeviceVideoGraph.Close();
	}
//	if( m_oAnalogDeviceAudioGraph.Create( L"CX2581 PCI, Analog WaveIn", bcb_audio, params ) == FALSE ) {
//
//		m_oAnalogDeviceAudioGraph.Close();
//	}
	for( ULONG i = 0 ; i < 32 ; i++ ) {

		g_n_video_frame_number[ i ] = 0;

		g_d_video_start_sample_time[ i ] = 0;

		g_d_video_stop_sample_time[ i ] = 0;

		g_n_audio_sample_number[ i ];

		g_d_audio_start_sample_time[ i ];

		g_d_audio_stop_sample_time[ i ];
	}
	m_oAnalogDeviceVideoGraph.Run();

//	m_oAnalogDeviceAudioGraph.Run();

	g_b_start_statsticis = TRUE;

	SetTimer( 0x00000000, 1000, NULL );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSC300Dlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	KillTimer( 0x00000000 );

	m_oAnalogDeviceAudioGraph.Stop();

	m_oAnalogDeviceVideoGraph.Stop();

	m_oAnalogDeviceAudioGraph.Close();

	m_oAnalogDeviceVideoGraph.Close();

	CoUninitialize();
}

void CSC300Dlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC300Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSC300Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSC300Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CSC300Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CSC300Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000000 ) {

		CHAR psz[ MAX_PATH * 4 ] = "";

		for( ULONG i = 0 ; i < 32 ; i++ ) {

			if( g_d_video_stop_sample_time[ i ] > g_d_video_start_sample_time[ i ] ) {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 4, "CH%02d: %7d, ", i + 1, (UINT)((g_n_video_frame_number[ i ] * 100000) / (g_d_video_stop_sample_time[ i ] - g_d_video_start_sample_time[ i ])) );
			}
			else {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 4, "CH%02d: %7d, ", i + 1, 0 );
			}
			if( i % 8 == 7 ) { StringCbPrintfA( psz + strlen(psz), MAX_PATH, "\n" ); }
		}
		for( i = 0 ; i < 32 ; i++ ) {

			if( g_d_audio_stop_sample_time[ i ] > g_d_audio_start_sample_time[ i ] ) {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 4, "CH%02d: %7d, ", i + 1, (UINT)((g_n_audio_sample_number[ i ] * 1000) / (g_d_audio_stop_sample_time[ i ] - g_d_audio_start_sample_time[ i ])) );
			}
			else {

				StringCbPrintfA( psz + strlen(psz), MAX_PATH * 4, "CH%02d: %7d, ", i + 1, 0 );
			}
			if( i % 8 == 7 ) { StringCbPrintfA( psz + strlen(psz), MAX_PATH, "\n" ); }
		}
		m_staticDebugCtrl.SetWindowText( psz );
	}
	CDialog::OnTimer(nIDEvent);
}
